# Graph neural networks: A review of methods and applications

图是一种数据结构，可对一组对象（节点）及其关系（边）进行建模。近年来，由于图的强大表达能力，利用机器学习来分析图的研究受到越来越多的关注，即图可以用作包括社会科学（社会网络（Wu et al。， 2020），自然科学（物理系统（Sanchez等，2018; Battaglia等，2016）和蛋白质-蛋白质相互作用网络（Fout等，2017）），知识图（Hamaguchi等，2017）和许多其他研究领域（Khalil等人，2017）。作为用于机器学习的独特非欧氏数据结构，图分析专注于节点分类，链接预测和聚类等任务；图神经网络（GNN）是基于深度学习的在图域上运行的方法，由于其令人信服的性能，GNN最近已成为一种广泛应用的图分析方法。在以下各段中，我们将说明图神经网络的基本动机。

Graphs are a kind of data structure which models a set of objects(nodes) and their relationships (edges). Recently, researches onanalyzing graphs with machine learning have been receiving more andmore attention because of the great expressive power of graphs, i.e.graphs can be used as denotation of a large number of systems acrossvarious areas including social science (social networks (Wu et al., 2020),natural science (physical systems (Sanchez et al., 2018;Battaglia et al.,2016) and protein-protein interaction networks (Fout et al., 2017)),knowledge graphs (Hamaguchi et al., 2017) and many other researchareas (Khalil et al., 2017). As a unique non-Euclidean data structure formachine learning, graph analysis focuses on tasks such as node classifi-cation, link prediction, and clustering. Graph neural networks (GNNs) aredeep learning based methods that operate on graph domain. Due to itsconvincing performance, GNN has become a widely applied graphanalysis method recently. In the following paragraphs, we will illustratethe fundamental motivations of graph neural networks.

GNN的第一个动机源于图形的神经网络的悠久历史。在90年代，递归神经网络首先用于有向无环图（Sperduti和Starita，1997； Frasconi等，1998）。之后，在（Scarselli等，2009）和（Micheli，2009）中分别将循环神经网络和前馈神经网络引入该文献以解决循环问题。虽然成功，但这些方法背后的通用思想是在图形上建立状态转换系统并迭代直到收敛，这限制了可扩展性和表示能力。深度神经网络特别是卷积神经网络（CNN）的最新进展（LeCun等， 1998年）重新发现了GNN。 CNN具有提取多尺度局部空间特征并将其组合以构建高度表达的表示的能力，这导致几乎所有机器学习领域都取得了突破，并开创了深度学习的新纪元（LeCun et al。，2015）。 CNN的关键是本地连接，共享权重和多层使用（LeCun et al。，2015）。这些对于解决图上的问题也非常重要。但是，CNN只能对诸如图像（2D网格）和文本（1D序列）之类的常规欧氏数据进行操作，而这些数据结构可以视为图的实例。因此，在图上泛化CNN很简单。 如图。 1，难以定义局部卷积滤波器和池化算子，这阻碍了CNN从欧几里德域向非欧几里德域的转换。 将深度神经模型扩展到非欧几里德域（通常称为几何深度学习）已经成为一个新兴的研究领域（Bronstein et al。，2017）。 在这个伞词下，图上的深度学习受到极大关注

The first motivation of GNNs roots in the long-standing history of neural networks for graphs. In the nineties, Recursive Neural Network sarefirst utilized on directed acyclic graphs (Sperduti and Starita, 1997;Frasconi et al., 1998). Afterwards, Recurrent Neural Networks and Feed-forward Neural Networks are introduced into this literature respectively in (Scarselli et al., 2009) and (Micheli, 2009) to tackle cy-cles. Although being successful, the universal idea behind these methods is building state transition systems on graphs and iterate until conver-gence, which constrained the extendability and representation ability. Recent advancement of deep neural networks, especially convolutional neural networks (CNNs) (LeCun et al., 1998) result in the rediscovery of GNNs. CNNs have the ability to extract multi-scale localized spatialfeatures and compose them to construct highly expressive representa-tions, which led to breakthroughs in almost all machine learning areasand started the new era of deep learning (LeCun et al., 2015).**The keys ofCNNs are local connection, shared weights and the use of multiple layers(LeCun et al., 2015). ** These are also of great importance in solvingproblems on graphs. However, CNNs can only operate on regularEuclidean data like images (2D grids) and texts (1D sequences) whilethese data structures can be regarded as instances of graphs. Therefore，it is straightforward to generalize CNNs on graphs. As shown in Fig. 1,it is hard to define localized convolutional filters and pooling operators,which hinders the transformation of CNN from Euclidean domain to non-Euclidean domain. Extending deep neural models to non-Euclideandomains, which is generally referred to as geometric deep learning, hasbeen an emerging research area (Bronstein et al., 2017). Under thisumbrella term, deep learning on graphs receives enormous attension

另一个动机来自图表示学习（Cuiet等人，2018a; Hamilton等人，2017b; Zhang等人，2018a; Cai等人，2018; Goyal和Ferrara，2018），该研究学习表示图节点，边或低维向量的子图。在图分析领域，传统的机器学习方法通常依赖于手工设计的功能，并且受其灵活性和高成本的限制。继表示学习的思想和词嵌入的成功（Mikolov等，2013）之后，DeepWalk（Perozzi等，2014）被认为是第一种基于表示学习的图嵌入方法，在其上应用了SkipGram模型（Mikolov等，2013）。类似的方法，例如node2vec（Grover和Leskovec，2016），LINE（Tang等人，2015）和TADW（Yang等人，2015）等类似方法也取得了突破。但是，这些方法存在两个严重缺陷（Hamilton等，2017b）。首先，编码器中的节点之间没有共享参数，这导致计算效率低下，因为它意味着参数的数量随节点的数量线性增长。其次，直接嵌入方法缺乏泛化能力，这意味着它们无法处理动态图或泛化为新图

The other motivation comes from graph representation learning(Cuiet al., 2018a;Hamilton et al., 2017b; Zhang et al., 2018a; Cai et al., 2018;Goyal and Ferrara, 2018), which learns to represent graph nodes, edgesor subgraphs by low-dimensional vectors. In thefield of graph analysis,traditional machine learning approaches usually rely on hand engineeredfeatures and are limited by its inflexibility and high cost. Following theidea ofrepresentation learningand the success of word embedding(Mikolov et al., 2013), DeepWalk (Perozzi et al., 2014), regarded as thefirst graph embedding method based on representation learning, appliesSkipGram model (Mikolov et al., 2013) on the generated random walks.Similar approaches such as node2vec (Grover and Leskovec, 2016), LINE(Tang et al., 2015) and TADW (Yang et al., 2015) also achieved break-throughs. However, these methods suffer from two severe drawbacks(Hamilton et al., 2017b). First, no parameters are shared between nodesin the encoder, which leads to computationally inefficiency, since itmeans the number of parameters grows linearly with the number ofnodes. Second, the direct embedding methods lack the ability of gener-alization, which means they cannot deal with dynamic graphs orgeneralize to new graph

基于CNN和图嵌入，提出了图神经网络（GNN）的变体，以聚集来自图结构的信息。 因此，他们可以对由元素及其相关性组成的输入，输入和/或输出进行建模。

Based on CNNs and graph embedding, variants of graph neural net-works (GNNs) are proposed to collectively aggregate information from graph structure. Thus they can model input andnput and/or output consisting ofelements and their dependency.

关于图神经网络有一些全面的综述。 （2017）对几何深度学习进行了全面的回顾，提出了它的问题，困难，解决方案，应用和未来的方向。 （2019a）提出了图卷积网络的另一种全面概述。 但是，它们主要关注图上定义的卷积运算符，而我们研究GNN中的其他计算模块，例如跳过连接和池化运算符

There exists several comprehensive reviews on graph neural net-works.Bronstein et al. (2017)provide a thorough review of geometricdeep learning, which presents its problems, difficulties, solutions, ap-plications and future directions.Zhang et al. (2019a)propose anothercomprehensive overview of graph convolutional networks. However,they mainly focus on convolution operators defined on graphs while weinvestigate other computation modules in GNNs such as skip connectionsand pooling operator

张等人的论文。 （2018b），Wu等。 （2019a），Chami等人。 （2020年）是有关GNN的最新调查论文，主要集中在GNN的模型上。 （2019a）将GNN分为四类：递归图神经网络，卷积图神经网络，图自动编码器和时空图神经网络。 （2018b）对不同的图深度学习方法和Chami等人进行了系统概述。 （2020）提出了一个Graph Encoder DecoderModel来统一网络嵌入和图形神经网络模型。本文提供了一种不同的分类法，我们主要关注经典的GNN模型。 此外，我们总结了不同图形类型的GNN的变体，还提供了GNN在不同领域中的应用的详细摘要。

Papers byZhang et al. (2018b),Wu et al. (2019a),Chami et al. (2020)are the most up-to-date survey papers on GNNs and they mainly focus onmodels of GNN.Wu et al. (2019a)categorize GNNs into four groups:recurrent graph neural networks, convolutional graph neural networks,graph autoencoders, and spatial-temporal graph neural networks.Zhanget al. (2018b)give a systematic overview of different graph deep learningmethods andChami et al. (2020)propose a Graph Encoder DecoderModel to unify network embedding and graph neural network models.Our paper provides a different taxonomy with them and we mainly focuson classic GNN models. Besides, we summarize variants of GNNs fordifferent graph types and also provide a detailed summary of GNNs’applications in different domains.

也有一些针对特定图形学习领域的调查。 （2018）和Chen等。 （2020a）提供了关于图的对抗学习方法的详细概述，包括图数据的攻击和防御。 （2018a）对石墨烯注意力模型进行了综述。 杨等人提出的论文。 （黄）等人（2020年）着重于异构图表示学习，其中节点或边是多种类型。 （Peng等，（2020））对现有GNN模型进行了回顾。 （2020）总结了用于组合优化的图嵌入方法。 我们分别在第4.2节，第4.3节和第8.1.6节中总结了用于异构图，动态图和组合优化的GNN。 应用程序。 概括地说，我们的贡献是：

There have also been several surveys focusing on some specific graphlearningfields.Sun et al. (2018)andChen et al. (2020a)give detailedoverviews for adversarial learning methods on graphs, including graphdata attack and defense.Lee et al. (2018a)provide a review over graphattention models. The paper proposed byYang et al. (2020)focuses onheterogeneous graph representation learning, where nodes or edges areof multiple types.Huang et al. (2020)review over existing GNN modelsfor dynamic graphs.Peng et al. (2020)summarize graph embeddingsmethods for combinatorial optimization. We conclude GNNs for het-erogeneous graphs, dynamic graphs and combinatorial optimization inSection4.2, Section4.3, and Section8.1.6respectively.In this paper, we provide a thorough review of different graph neuralnetwork models as well as a systematic taxonomy of the applications. Tosummarize, our contributions are:

我们对现有的图神经网络模型进行了详细的回顾。 我们提出了一个总体设计流程，并讨论了每个模块的变体。 我们还将介绍有关理论和理论的研究。

We provide a detailed review over existing graph neural network models. We present a general design pipeline and discuss the variants of each module. We also introduce researches on theoretical and empirical  analyses of GNN models

我们对应用程序进行系统分类，并将应用程序分为结构性场景和非结构性场景。 针对每种情况，我们介绍了几种主要的应用程序及其相应的方法，并提出了四个未解决的问题，供以后研究。 我们对每个问题进行详尽的分析，并提出未来的研究方向。

We systematically categorize the applications and divide the appli-cations into structural scenarios and non-structural scenarios. Wepresent several major applications and their corresponding methodsfor each scenario.We propose four open problems for future research. We provide athorough analysis of each problem and propose future researchdirections.

本调查的其余部分安排如下。 在第2节中，我们介绍了通用的GNN设计管道。 遵循管道，我们将详细讨论每个步骤，以复习GNN模型的变体。 详细信息包含在第6节的第3节中。 在第7节中，我们将对GNN的理论和实证分析进行回顾。 在第8节中，我们介绍了图神经网络在结构场景，非结构场景和其他场景中的各种主要应用。 在第9节中，我们提出了图神经网络的四个开放性问题以及未来的研究方向。 最后，我们在第10节中完成了调查

The rest of this survey is organized as follows. In Section2, we presenta general GNN design pipeline. Following the pipeline, we discuss eachstep in detail to review GNN model variants. The details are included in Section 3 to Section6. In Section7, we revisit research works over theoretical and empirical analyses of GNNs. In Section8, we introduce several major applications of graph neural networks applied to structuralscenarios, non-structural scenarios and other scenarios. In Section9,wepropose four open problems of graph neural networks as well as severalfuture research directions. Andfinally, we conclude the survey in Section10